//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;

    /// <summary>
    /// Represents the sale position.
    /// </summary>
    public interface ISalePosition
    {
		/// <summary>
		/// Gets a product linked with this position.
		/// </summary>
        IProduct getProduct();

		/// <summary>
		/// Returns a number of product items.
		/// </summary>
		int getQuantity();

		/// <summary>
		/// Returns an amount of the position.
		/// </summary>
		Decimal getAmount();
    }
}
